 ; Ŀ
 ;   Surf - make a rectangular wipeout entity, bring objects behind it     
 ;   to the front ... most of them.                                        
 ;   Copyright 2004, 2006, 2007, 2009, 2010 by Rocket Software Ltd.        
 ;   Surfari was too long a name, if a better one.                         
 ; 

 ; Ŀ
 ;   Subroutine Boxo - get four corner points.                             
 ;   Takes no arguments, returns a list: (ll ul ur lr).                    
 ; 
 (DEFUN BOXO (/ aa cc bb dd htp wdthp)
  (setq aa (getpoint "First corner:"))
  (if (setq cc (getcorner aa "\nOpposite corner or <Return> to specify: "))
     (progn
          (setq bb (cons (car cc) (cdr aa)))
          (setq dd (cons (car aa) (cdr cc))))
     (progn
          (if (or (= (type wdth) 'INT) (= (type wdth) 'REAL))
              (progn
                   (setq wdthp (getdist aa (strcat "\nWidth <"
                                                   (rtos wdth 2 2) ">: ")))
                   (if wdthp (setq wdth wdthp)))
              (setq wdth (getdist aa "\nWidth: ")))
          (if (or (and (/= (type ht) 'INT) (/= (type ht) 'REAL))
                  wdthp)
              (setq ht wdth))
          (setq htp (getdist aa (strcat "\nand height <"
                                        (rtos ht 2 2) ">: ")))
          (if htp (setq ht htp))
          (setq bb (polar aa 0 wdth))
          (setq cc (polar (polar aa 0 wdth) (* pi 1.5) ht))
          (setq dd (polar aa (* pi 1.5) ht))))
 (list aa bb cc dd))
 ; Ŀ
 ;   Subroutine Boxo end.                                                  
 ; 

 ; Ŀ
 ;   Subroutine Deflep - make the Defpoints layer or make it current.      
 ;   Brooks no arguments, calls nothing, returns t or nil.                 
 ; 
 (DEFUN DEFLEP (/ lanam revisp laset)
  (setq lanam "defpoints")
 ; Ŀ
 ;   See if the desired layer is ready to use.                             
 ; 
  (if (setq revisp (tblsearch "layer" lanam))
      (setq laset (layp lanam)))
 ; Ŀ
 ;   Act appropriately.                                                    
 ; 
  (cond ((and revisp (null laset))
         (setvar "clayer" lanam))
        ((null laset)
         (command "-layer" "m" lanam ""))
        (laset
         (prompt (strcat "\n* The " lanam " layer is " (car laset) ". *\n"))))
 (if laset () t))
 ; Ŀ
 ;   Deflep end.                                                           
 ; 

 ; Ŀ
 ;   Layp - see if a layer is off, locked, or frozen.                      
 ;   Takes one argument, a layer name.                                     
 ;   Returns a list of conditions or nil                                   
 ; 
 (DEFUN LAYP (lanam / llist sev col stalst)
  (setq llist (tblsearch "layer" lanam))
  (setq sev (cdr (assoc 70 llist)))
  (setq col (cdr (assoc 62 llist)))
  (if (= (logand sev 1) 1) (setq stalst (list "frozen")))
  (if (= (logand sev 4) 4) (setq stalst (cons "locked" stalst)))
  (if (minusp col) (setq stalst (cons "off" stalst)))
 stalst)
 ; Ŀ
 ;   Layp end.                                                             
 ; 

 ; Ŀ
 ;   Mag - make a randomly named group.                                    
 ;   Argument: Ss, a selection set of stuff to group.                      
 ;   Returns a group name.                                                 
 ; 
 (DEFUN MAG (ss / namm)
 ; Ŀ
 ;   Concoct a group name.                                                 
 ; 
  (setq lup (getvar "luprec"))              ; don't make local
  (setvar "luprec" 8)
  (setq namm (rtos (getvar "date")))        ; get exact time
  (setq namm (strcat "G" (substr namm 9)))
  (setvar "luprec" lup)
 ; Ŀ
 ;   Make the group.                                                       
 ; 
  (command ".group" "" namm "" ss "")
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
 namm)
 ; Ŀ
 ;   Mag end.                                                              
 ; 

 ; Ŀ
 ;   Surf.                                                                 
 ; 
 (DEFUN C:SURF (/ *error* osm snapp ss enam lup osm ss ptsa lr ll ul ur topss
                                                                     num enam)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osm (getvar "osmode"))
  (setvar "osmode" 0)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (setq clayer (getvar "clayer"))
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "osmode" osm)
   (setvar "snapmode" snapp)
   (setvar "clayer" clayer)
   (if lup (setvar "luprec" lup))
   (command ".undo" "end")
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   Get stuff not to bring to the front.                                  
 ; 
  (prompt "Select things to not cover: ")
  (setq ss (ssget))
 ; Ŀ
 ;   Get four corner points.                                               
 ; 
  (setvar "snapmode" snapp)
  (setq ptsa (setq lr (boxo)))
  (setq ll (car lr))
  (setq ul (cadr lr))
  (setq ur (caddr lr))
  (setq lr (cadddr lr))
 ; Ŀ
 ;   Make the Defpoints layer current.                                     
 ;   Is this a good idea?  And if so then why turn frames off?             
 ;   No - it is flaky with recent releases.                                
 ; 
 ;(deflep)
  (setvar "clayer" (cdr (assoc 8 (entget (ssname ss 0)))))
 ; Ŀ
 ;   Draw a wipeout.                                                       
 ; 
  (command ".wipeout" ll ul ur lr "")
  (setq enam (entlast))
 ; Ŀ
 ;   Bring everything in the ss to the front.                              
 ; 
  (command "draworder" ss "" "front")
 ; Ŀ
 ;   Group it.                                                             
 ; 
  (ssadd enam ss)
  (mag ss)
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))